/*
 * Decompiled with CFR 0.152.
 */
package frc.emul.vectrex.ui.config;

import frc.emul.config.Configuration;
import frc.emul.config.data.CfgItemJoystick;
import frc.emul.config.data.CfgItemKey;
import frc.emul.config.data.CfgItemKeySwitch;
import frc.emul.config.data.CfgItemKeymapping;
import frc.emul.util.Utils;
import frc.emul.util.swing.AALabel;
import frc.emul.vectrex.Vectrex;
import frc.emul.vectrex.ui.Borders;
import frc.emul.vectrex.ui.config.UIUtils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.SpringLayout;
import javax.swing.SwingUtilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UIKeyMapper {
    public void configChanged() {
    }

    public static void applyConfig(Configuration configuration) {
        Vectrex.INSTANCE.getPeripherals().applyConfiguration(configuration);
    }

    public void openSettingsEditor(Window window, Configuration configuration, boolean bl) {
        final JDialog jDialog = UIUtils.createDialog(window, "ParaJVE - Key Mapping", true);
        JPanel jPanel = new JPanel(new BorderLayout(0, 0));
        JButton jButton = new JButton(" O K ");
        jPanel.add((Component)jButton, "East");
        UIUtils.registerEscapeButton(jButton, new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                jDialog.dispose();
            }
        });
        AALabel aALabel = new AALabel("Press the buttons to redefine key mappings");
        aALabel.setHorizontalAlignment(0);
        Container container = jDialog.getContentPane();
        container.setLayout(new BorderLayout(10, 10));
        JComponent jComponent = this.buildMain(configuration, bl);
        container.add((Component)aALabel, "North");
        container.add((Component)jComponent, "Center");
        container.add((Component)jPanel, "South");
        UIUtils.setContainerBorder(container);
        jDialog.pack();
        UIUtils.center(jDialog, window, 0, 0);
        jDialog.getRootPane().setDefaultButton(jButton);
        jDialog.setResizable(false);
        jDialog.setVisible(true);
    }

    private JComponent buildMain(Configuration configuration, boolean bl) {
        ArrayList<Binding> arrayList = new ArrayList<Binding>(40);
        JTabbedPane jTabbedPane = new JTabbedPane(1);
        JPanel jPanel = new JPanel(new SpringLayout());
        jPanel.setBorder(Borders.EMPTY_10);
        int n = 2;
        n += this.addKeyBinder(arrayList, jPanel, "Toggle Menu", configuration.keyMapping.keyMenu);
        n += this.addKeyBinder(arrayList, jPanel, "Optimize Window Size", configuration.keyMapping.keySizeOptim);
        jPanel.add(Box.createVerticalStrut(4));
        jPanel.add(Box.createVerticalStrut(4));
        n += this.addKeyBinder(arrayList, jPanel, "Save", configuration.keyMapping.keySave);
        n += this.addKeyBinder(arrayList, jPanel, "Load", configuration.keyMapping.keyLoad);
        n += this.addKeyBinder(arrayList, jPanel, "Quick Save", configuration.keyMapping.keyQuickSave);
        n += this.addKeyBinder(arrayList, jPanel, "Quick Load", configuration.keyMapping.keyQuickLoad);
        jPanel.add(Box.createVerticalStrut(4));
        jPanel.add(Box.createVerticalStrut(4));
        n += this.addKeyBinder(arrayList, jPanel, "ScreenShot", configuration.keyMapping.keySnapShot);
        n += this.addKeyBinder(arrayList, jPanel, "Pause", configuration.keyMapping.keyPause);
        n += this.addKeyBinder(arrayList, jPanel, "Reset", configuration.keyMapping.keyReset);
        UIUtils.makeCompactGrid(jPanel, n += this.addKeyBinder(arrayList, jPanel, "Exit", configuration.keyMapping.keyExit, bl), 2, 0, 0, 10, 6);
        jTabbedPane.addTab("  General keys  ", UIKeyMapper.createBorderPanel(jPanel, null, null));
        jTabbedPane.addTab("  Joystick #1  ", this.buildJoy(arrayList, configuration.keyMapping.joy1, Kind.JOYSTICK1));
        jTabbedPane.addTab("  Joystick #2  ", this.buildJoy(arrayList, configuration.keyMapping.joy2, Kind.JOYSTICK2));
        jTabbedPane.addTab("  PS/2 Keyboard Adapter  ", this.buildKeyboard(arrayList, configuration.keyMapping.keyboard));
        return jTabbedPane;
    }

    private JComponent buildJoy(List<Binding> list, CfgItemJoystick cfgItemJoystick, Kind kind) {
        JPanel jPanel = new JPanel(new SpringLayout());
        jPanel.setBorder(Borders.EMPTY_10);
        this.addKeyBinder(list, jPanel, "Button 1", cfgItemJoystick.keyBtn1, kind);
        this.addKeyBinder(list, jPanel, "Button 2", cfgItemJoystick.keyBtn2, kind);
        this.addKeyBinder(list, jPanel, "Button 3", cfgItemJoystick.keyBtn3, kind);
        this.addKeyBinder(list, jPanel, "Button 4", cfgItemJoystick.keyBtn4, kind);
        jPanel.add(Box.createVerticalStrut(4));
        jPanel.add(Box.createVerticalStrut(4));
        this.addKeyBinder(list, jPanel, "Up", cfgItemJoystick.keyUp, kind);
        this.addKeyBinder(list, jPanel, "Down", cfgItemJoystick.keyDown, kind);
        this.addKeyBinder(list, jPanel, "Left", cfgItemJoystick.keyLeft, kind);
        this.addKeyBinder(list, jPanel, "Right", cfgItemJoystick.keyRight, kind);
        UIUtils.makeCompactGrid(jPanel, 9, 2, 0, 0, 10, 6);
        return UIKeyMapper.createBorderPanel(jPanel, null, null);
    }

    private JComponent buildKeyboard(List<Binding> list, CfgItemKeySwitch cfgItemKeySwitch) {
        JPanel jPanel = new JPanel(new SpringLayout());
        jPanel.setBorder(Borders.EMPTY_10);
        this.addKeyBinder(list, jPanel, "Engage Keyboard", cfgItemKeySwitch.keyON, Kind.KEYBOARD);
        this.addKeyBinder(list, jPanel, "Disengage Keyboard", cfgItemKeySwitch.keyOFF, Kind.KEYBOARD);
        UIUtils.makeCompactGrid(jPanel, 2, 2, 0, 0, 10, 6);
        String string = "<html><b>When the Keyboard Adapter is plugged into the game port,<br>it remains <u>inactive</u> until you press the engagement key.<br><br></b>Once the keyboard has been activated, it will intercept any keypress<br>(including the keys already mapped to joysticks or the general keys).<br>This will last until the keyboard is disengaged.<br><br>This section lets you define the keys that switch the keyboard on/off<br>(you may set the same key both for engaging and disengaging).</html>";
        JLabel jLabel = UIUtils.buildCommentsLabel(string);
        JPanel jPanel2 = new JPanel(new BorderLayout(10, 10));
        jPanel2.add((Component)jLabel, "North");
        jPanel2.add((Component)jPanel, "Center");
        jPanel2.setBorder(Borders.EMPTY_10);
        return UIKeyMapper.createBorderPanel(jPanel2, null, null);
    }

    private int addKeyBinder(List<Binding> list, JPanel jPanel, String string, CfgItemKey cfgItemKey, boolean bl) {
        if (bl) {
            return this.addKeyBinder(list, jPanel, string, cfgItemKey, Kind.STANDARD);
        }
        return 0;
    }

    private int addKeyBinder(List<Binding> list, JPanel jPanel, String string, CfgItemKey cfgItemKey) {
        return this.addKeyBinder(list, jPanel, string, cfgItemKey, Kind.STANDARD);
    }

    private int addKeyBinder(final List<Binding> list, JPanel jPanel, final String string, CfgItemKey cfgItemKey, Kind kind) {
        final JButton jButton = new JButton(string);
        JLabel jLabel = new JLabel(UIKeyMapper.getKeyLabel(CfgItemKeymapping.getVkString(cfgItemKey.getCode(), true)));
        jLabel.setBorder(Borders.BEVEL_LOW);
        jLabel.setHorizontalAlignment(0);
        jPanel.add(jButton);
        JPanel jPanel2 = new JPanel(new GridLayout(1, 1, 0, 0));
        jPanel2.add(jLabel);
        jPanel.add(jPanel2);
        final Binding binding = new Binding(cfgItemKey, jLabel, string, kind);
        list.add(binding);
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JDialog jDialog = (JDialog)SwingUtilities.getWindowAncestor(jButton);
                final JDialog jDialog2 = new JDialog(jDialog, "ParaJVE - Redefine Key...", true);
                Container container = jDialog2.getContentPane();
                UIUtils.setContainerBorder(container);
                container.setLayout(new GridLayout(0, 1));
                jDialog2.setDefaultCloseOperation(2);
                AALabel aALabel = new AALabel("<html><center>Press the new key for :<br><font size=+1>" + string + "</font><br><br><br>(or click in this dialog to cancel)");
                aALabel.setHorizontalAlignment(0);
                container.add(aALabel);
                jDialog2.addKeyListener(new KeyAdapter(){

                    public void keyReleased(KeyEvent keyEvent) {
                        if (keyEvent.getKeyCode() == 154 && Utils.isWindowsOS()) {
                            this.keyPressed(keyEvent);
                        }
                    }

                    public void keyPressed(KeyEvent keyEvent) {
                        if (UIKeyMapper.handleKeypress(jDialog2, keyEvent, binding, list)) {
                            UIKeyMapper.this.configChanged();
                            jDialog2.dispose();
                        }
                    }
                });
                aALabel.addMouseListener(new MouseAdapter(){

                    public void mouseClicked(MouseEvent mouseEvent) {
                        jDialog2.dispose();
                    }
                });
                jDialog2.setBounds(jDialog.getBounds());
                jDialog2.setResizable(false);
                jDialog2.setVisible(true);
            }
        });
        return 1;
    }

    private static String getKeyLabel(String string) {
        return "    " + string + "    ";
    }

    private static JComponent createBorderPanel(JComponent jComponent, JComponent jComponent2, JComponent jComponent3) {
        JPanel jPanel = new JPanel(new BorderLayout(0, 0));
        if (jComponent != null) {
            jPanel.add((Component)jComponent, "North");
        }
        if (jComponent2 != null) {
            jPanel.add((Component)jComponent2, "Center");
        }
        if (jComponent3 != null) {
            jPanel.add((Component)jComponent3, "South");
        }
        return jPanel;
    }

    private static boolean handleKeypress(JDialog jDialog, KeyEvent keyEvent, Binding binding, List<Binding> list) {
        int n = keyEvent.getKeyCode();
        if (n != 0) {
            keyEvent.consume();
            String string = CfgItemKeymapping.getVkString(n, false);
            if (string != null && UIKeyMapper.handleDuplicateKeys(jDialog, n, binding, list)) {
                binding.key.set(string);
                binding.lbl.setText(UIKeyMapper.getKeyLabel(string));
                return true;
            }
        }
        return false;
    }

    private static boolean handleDuplicateKeys(JDialog jDialog, int n, Binding binding, List<Binding> list) {
        for (Binding binding2 : list) {
            if (binding == binding2 || n != binding2.key.getCode() || binding.kind == Kind.KEYBOARD && binding2.kind == Kind.KEYBOARD) continue;
            Binding[] bindingArray = UIKeyMapper.askForMappingSwitch(jDialog, binding, binding2, list);
            if (bindingArray == null) {
                return false;
            }
            Binding[] bindingArray2 = bindingArray;
            int n2 = bindingArray.length;
            int n3 = 0;
            while (n3 < n2) {
                Binding binding3 = bindingArray2[n3];
                if (binding3 != null) {
                    binding3.key.set(binding.key.getCode());
                    binding3.lbl.setText(binding.lbl.getText());
                }
                ++n3;
            }
            return true;
        }
        return true;
    }

    private static Binding[] askForMappingSwitch(JDialog jDialog, Binding binding, Binding binding2, List<Binding> list) {
        int n;
        Object object;
        String string = "<html>The \" <b><code>" + binding2.key.getString(true) + "</code></b> \" shortcut key is already in use by another mapping : [ <b>" + binding2 + "</b> ]&nbsp;&nbsp;<br><br>" + "If you proceed, the following changes will be made:<ol>" + "<li>The shortcut for  [ <b>" + binding + "</b> ]  will be changed to \" <b><code>" + binding2.key.getString(true) + "</code></b> \"&nbsp;&nbsp;</li>" + "<li>The shortcut for  [ <b>" + binding2 + "</b> ]  will be changed to \" <b><code>" + binding.key.getString(true) + "</code></b> \"&nbsp;&nbsp;</li>";
        Binding[] bindingArray = new Binding[2];
        bindingArray[0] = binding2;
        if (binding2.kind == Kind.KEYBOARD) {
            object = UIKeyMapper.getPeerKeyboardBinding(binding2, list);
            if (binding2.key.getCode() == ((Binding)object).key.getCode()) {
                bindingArray[1] = object;
                string = String.valueOf(string) + "<li>The shortcut for  [ <b>" + object + "</b> ]  will be changed to \" <b><code>" + binding.key.getString(true) + "</code></b> \"&nbsp;&nbsp;</li>";
            }
        }
        return (n = JOptionPane.showConfirmDialog(jDialog, object = new AALabel(String.valueOf(string) + "</ol>"), "Duplicate key mapping", 2, 1)) == 0 ? bindingArray : null;
    }

    private static Binding getPeerKeyboardBinding(Binding binding, List<Binding> list) {
        for (Binding binding2 : list) {
            if (binding2.kind != Kind.KEYBOARD || binding == binding2) continue;
            return binding2;
        }
        throw new IllegalStateException("A peer keyboard binding must always exist");
    }

    private class Binding {
        private final CfgItemKey key;
        private final JLabel lbl;
        private final String txt;
        private final Kind kind;

        Binding(CfgItemKey cfgItemKey, JLabel jLabel, String string, Kind kind) {
            this.key = cfgItemKey;
            this.lbl = jLabel;
            this.txt = string;
            this.kind = kind;
        }

        public String toString() {
            switch (this.kind) {
                case JOYSTICK1: {
                    return "Joystick 1 " + this.txt;
                }
                case JOYSTICK2: {
                    return "Joystick 2 " + this.txt;
                }
            }
            return this.txt;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum Kind {
        STANDARD,
        JOYSTICK1,
        JOYSTICK2,
        KEYBOARD;

    }
}

